/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OverslimeArmyModifier
extends Modifier
implements ConditionalStatModifierHook {
    public int getPriority() {
        return 70;
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        int current = overslime.getOverslime(tool);
        if (current > 0) {
            event.setNewSpeed((float)((double)event.getNewSpeed() + Math.cbrt((float)current * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED))));
        }
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        int current = overslime.getOverslime(tool);
        if (current > 0) {
            return (float)((double)damage + Math.cbrt((float)current * tool.getMultiplier((INumericToolStat)ToolStats.ATTACK_DAMAGE)));
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.DRAW_SPEED) {
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            float current = overslime.getOverslime(tool);
            return (float)((double)baseValue + Math.cbrt((double)current * 0.004 * (double)tool.getMultiplier((INumericToolStat)ToolStats.DRAW_SPEED)));
        }
        return baseValue;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        int current = overslime.getOverslime(tool);
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if ((harvest || tool.hasTag(TinkerTags.Items.RANGED)) && player != null && key == TooltipKey.SHIFT) {
            if (harvest) {
                this.addDamageTooltip(tool, (float)Math.cbrt(current), tooltip);
                this.addSpeedTooltip(tool, (float)Math.cbrt(current), tooltip);
            } else {
                this.addStatTooltip(tool, ToolStats.DRAW_SPEED, TinkerTags.Items.RANGED, (float)Math.cbrt((double)current * 0.004), tooltip);
            }
        }
    }

    protected void addSpeedTooltip(IToolStackView tool, float amount, List<Component> tooltip) {
        this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.MELEE_OR_UNARMED, amount, tooltip);
    }
}

